<?php
// ========================================================================
// Moderation Auto-PM
// Automaticly sends a PM when a thread, post or attachment is moderated
// Version 2.0.1
// ------------------------------------------------------------------------
// FUNCTIONS_AUTOPM.PHP - Called from the plugins
// ------------------------------------------------------------------------
// Written by Alan Wagstaff
// Copyright (C) 2006 Alan Wagstaff
// ========================================================================

/**
 * Function to prepare and send the private messages
 *
 * @param 	int		The unique ID for the item (threadid, postid, userid, etc)
 * @param 	char	What action is being done (stick, copy, edit, delete, etc)
 * @param 	char	Type of item (thread, post or attachment)
 * @param 	int		If thread, then the forum it's in, if post, then the threadid
 * @param 	int		If thread move, the forumid it's being moved to
 * @param 	char	The deletion / edit reason
 * @param 	char	Any extra info, currently only used for title edits - holds the new title
 * 
 * @return 	bool
 */
function mod_autopm($itemid, $action, $type, $source, $dest = 0, $reason = '', $extra = '')
{

	global $vbulletin, $vbphrase;

	// ====================================================================
	// Create the AutoPM Objects
	if (!$autopm_checker = new autopm_checker($vbulletin, $action, $type))
	{
		return false;
	}

	if (!$autopm_parser = new autopm_parser($vbulletin))
	{
		return false;
	}

	// ====================================================================
	// Check vb options to see if we can send a pm
	if (!$autopm_checker->check_send_status())
	{
		// Nope, bye-bye
		return false;
	}

	// ====================================================================
	// Check the forum exclude list
	if (($autopm_checker->exclude !== FALSE) AND (in_array($source, $autopm_checker->exclude) OR in_array($dest, $autopm_checker->exclude)))
	{
		// Don't send a PM
		return false;
	}

	// ====================================================================
	// Fetch the PM title
	$pm_title = $vbphrase['autopm_title_' . $type . '_' . $action];

	// ====================================================================
	// Construct the PM text
	$autopm_parser->phrasetext = $vbphrase['autopm_text_' . $type . '_' . $action];
	$autopm_parser->item_id = $itemid;
	$autopm_parser->source = $source;
	$autopm_parser->dest = $dest;
	$autopm_parser->item_type = $type;
	$autopm_parser->action = $action;
	$autopm_parser->reason = $reason;
	$autopm_parser->extra = $extra;

	// Last minute checks
	$autopm_parser->check_recycle_bin();

	$autopm_parser->fetch_items();
	$autopm_parser->set_items($autopm_parser->items);

	$autopm_parser->parse_phrase();
	$pm_text = $autopm_parser->get_phrasetext_parsed();

	// Add the signature to the PM text
	$pm_text .= "\r\n\r\n" . $vbulletin->options['cit_autopm_signature'];

	// ====================================================================
	// Send the PM
	// No Doubt we'll find a few Spiderwebs in here

	// Check we're not sending a PM to ourselves
	if ($autopm_parser->items['{user_id}'] == $vbulletin->userinfo['userid'])
	{
		return false;
	}

	// Get the userid/name to send the message from
	if ($vbulletin->options['cit_autopm_fromid'])
	{
		// Get the username (has to be valid unfortunately due to 1 line in vB's PM code)
		$username_a = $vbulletin->db->query_first("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid=" . $vbulletin->options['cit_autopm_fromid']);

		$senderid = $vbulletin->options['cit_autopm_fromid'];
		$sendername = $username_a['username'];
	}
	else
	{
		// Use the mods details
		$senderid = $vbulletin->userinfo['userid'];
		$sendername = $vbulletin->userinfo['username'];
	}

	// Init the PM datamanager
	$pm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);

	// Force the PM through
	$pmperms['adminpermissions'] = 2;

	// Fill in the blanks
	$pm->set('fromuserid', $senderid);
	$pm->set('fromusername', $sendername);
	$pm->set('title', $pm_title);
	$pm->set('message', $pm_text);
	$pm->set_recipients($autopm_parser->recipient, $pmperms);
	$pm->set('dateline', time());

	// Check for errors (and then promptly ignore them)
	if (empty($pm->errors))
	{
		// There are no errors, so send the PM
		$pm->save();
	}

	return true;

}

// Say Bye Bye!  We love you Backstreet Boys!

?>